// priority: 100
onEvent('recipes', (event) => {

    //Define possible miners
    let MINER = {
        Ores: 'occultism:miners/ores',
        Resources: 'occultism:miners/basic_resources'
    }

    //Allows adding a miner recipe
    const miner = (minerType, result, weight) => {
        if (result.startsWith('#')) {
            event.custom({
                type: 'occultism:miner',
                ingredient: {
                    tag: minerType
                },
                result: {
                    tag: result
                },
                weight: weight
            });
        } else {
            event.custom({
                type: 'occultism:miner',
                ingredient: {
                    tag: minerType
                },
                result: {
                    item: result
                },
                weight: weight
            });
        }
    }

    //Resources
    miner(MINER.Resources, 'minecraft:stone', 15)
    miner(MINER.Resources, 'minecraft:deepslate', 15)
    miner(MINER.Resources, 'create:cut_veridium', 5)
    miner(MINER.Resources, 'create:ochrum', 5)
    miner(MINER.Resources, 'create:crimsite', 5)
    miner(MINER.Resources, 'create:asurine', 5)
    miner(MINER.Resources, 'ae2:sky_stone_block', 15)
    miner(MINER.Resources, 'soul_ice:lightstone', 15)
    miner(MINER.Resources, 'minecraft:clay', 15)
    miner(MINER.Resources, 'quark:limestone', 15)
    miner(MINER.Resources, 'minecraft:glowstone', 10)

    //Ores -- use Botania's weights for OreChid with Deepslate, and use deepslate ores too.
    //Tier 2: 50
    miner(MINER.Ores, 'minecraft:deepslate_coal_ore', 50)
    miner(MINER.Ores, 'immersiveengineering:deepslate_ore_aluminum', 50)
    miner(MINER.Ores, 'thermal:deepslate_sulfur_ore', 50)
    miner(MINER.Ores, 'thermal:deepslate_niter_ore', 50)
    miner(MINER.Ores, 'thermal:deepslate_apatite_ore', 50)
    //Tier 3: 50
    miner(MINER.Ores, 'minecraft:deepslate_copper_ore', 50)
    miner(MINER.Ores, 'minecraft:deepslate_iron_ore', 50)
    miner(MINER.Ores, 'minecraft:deepslate_redstone_ore', 50)
    miner(MINER.Ores, 'thermal:deepslate_lead_ore', 50)
    miner(MINER.Ores, 'thermal:deepslate_silver_ore', 50)
    miner(MINER.Ores, 'create:deepslate_zinc_ore', 50)
    miner(MINER.Ores, 'mysticalagriculture:deepslate_prosperity_ore', 50)
    miner(MINER.Ores, 'ae2:deepslate_quartz_ore', 50)
    miner(MINER.Ores, 'malum:deepslate_soulstone_ore', 50)
    miner(MINER.Ores, 'thermal:deepslate_tin_ore', 50)
    miner(MINER.Ores, 'thermal:deepslate_cinnabar_ore', 50)
    miner(MINER.Ores, 'hearthstones:deepslate_aquamarine_ore', 50)
    //Tier 4: 40
    miner(MINER.Ores, 'minecraft:deepslate_lapis_ore', 40)
    miner(MINER.Ores, 'minecraft:deepslate_gold_ore', 40)
    miner(MINER.Ores, 'mekanism:deepslate_osmium_ore', 40)
    miner(MINER.Ores, 'thermal:deepslate_nickel_ore', 40)
    miner(MINER.Ores, 'mekanism:deepslate_uranium_ore', 40)
    miner(MINER.Ores, 'mekanism:deepslate_fluorite_ore', 40)
    miner(MINER.Ores, 'malum:brilliant_deepslate', 40)
    miner(MINER.Ores, 'thermal:deepslate_sapphire_ore', 40)
    miner(MINER.Ores, 'thermal:deepslate_ruby_ore', 40)
    //Tier 5: 30
    miner(MINER.Ores, 'minecraft:deepslate_diamond_ore', 30)
    miner(MINER.Ores, 'minecraft:deepslate_emerald_ore', 30)

    //The difference here... is that Dimensional Mineshaft can get Nether ores too.
    //Adjust weights
    miner(MINER.Ores, 'malum:blazing_quartz_ore', 50)
    miner(MINER.Ores, 'elementaryores:ore_iron_nether', 50)
    miner(MINER.Ores, 'elementaryores:ore_lapis_nether', 40)
    miner(MINER.Ores, 'minecraft:nether_gold_ore', 40)
    miner(MINER.Ores, 'minecraft:nether_quartz_ore', 30)
    miner(MINER.Ores, 'elementaryores:ore_ghast_nether', 20)
    miner(MINER.Ores, 'tconstruct:cobalt_ore', 20)
    miner(MINER.Ores, 'minecraft:ancient_debris', 20)

    //Not going to give end ores for that one, neither self Iesmium mining

    //-----

    //Crushing recipes compat
    //The rest of compat recipes are already added by JAOPCA (mod) :) so well done to JAOPCA!

    //material: Name of a material registered to 'forge:ores/'
    //dustItem: Full localized resource name of item output
    //amountOutput: How many items outputted you want, specify 2 for default amount
    const crushOre = (material, dustItem, amountOutput) => {
        event.custom({
            type: 'occultism:crushing',
            ingredient: {
                tag: 'forge:ores/' + material.toString()
            },
            result: {
                item: dustItem,
                count: amountOutput
            },
            crushing_time: 200
        });
    }

    //Gem ores
    crushOre('coal', 'minecraft:coal', 2)
    crushOre('redstone', 'minecraft:redstone', 6)
    crushOre('emerald', 'minecraft:emerald', 2)
    crushOre('lapis', 'minecraft:lapis_lazuli', 10)
    crushOre('diamond', 'minecraft:diamond', 2)
    crushOre('quartz', 'minecraft:quartz', 2)
    crushOre('dimensional_shard', 'rftoolsbase:dimensionalshard', 2)
    crushOre('prosperity', 'mysticalagriculture:prosperity_shard', 2)
    crushOre('soulium', 'mysticalagriculture:soulium_dust', 2)
    crushOre('certus_quartz', 'ae2:certus_quartz_dust', 2)
    crushOre('fluorite', 'mekanism:fluorite_gem', 2)
    crushOre('aquamarine', 'hearthstones:aquamarine', 2)
    crushOre('blazing_quartz', 'malum:blazing_quartz', 2)
    crushOre('soulstone', 'malum:raw_soulstone', 2)
    crushOre('apatite', 'thermal:apatite', 2)
    crushOre('cinnabar', 'thermal:cinnabar', 2)
    crushOre('niter', 'thermal:niter', 2)
    crushOre('sulfur', 'thermal:sulfur', 2)
    crushOre('ruby', 'thermal:ruby', 2)
    crushOre('sapphire', 'thermal:sapphire', 2)

    //Fix iesnium blasting, reported at https://github.com/klikli-dev/occultism/issues/783
    event.recipes.minecraft.blasting('occultism:iesnium_ingot', 'occultism:iesnium_dust').xp(0.7).cookingTime(200).id('occultism:blasting/iesnium_ingot_from_dust');
});